/* Score a new data set by saving the      */
/* parameter estimates for use on new data */
/* using OUTEST= and PROC SCORE            */
proc logistic data=develop des outest=betas1;
   model ins=dda ddabal dep depamt cashbk checks;
run;

proc print data=betas1;
run;

proc score data=pmlr.new 
           out=scored 
           score=betas1 
           type=parms;
   var dda ddabal dep depamt cashbk checks;
run;

data scored;
   set scored;
   p=1/(1+exp(-ins));
run;

proc print data=scored(obs=20);
   var p ins dda ddabal dep depamt cashbk checks;
run;
